//[BotStacks Chat SDK](../../../index.md)/[ai.botstacks.sdk.state](../index.md)/[ChatType](index.md)

# ChatType

[common]\
enum [ChatType](index.md) : [Enum](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-enum/index.html)&lt;[ChatType](index.md)&gt; 

The type of a Chat entity.

## Entries

| | |
|---|---|
| [DirectMessage](-direct-message/index.md) | [common]<br>[DirectMessage](-direct-message/index.md)<br>A persistent Chat between two users. |
| [Group](-group/index.md) | [common]<br>[Group](-group/index.md)<br>A persistent Chat created for a group of people. Can be branded with a name, description and image, as well as members with MemberRoles |
| [Conversation](-conversation/index.md) | [common]<br>[Conversation](-conversation/index.md)<br>Represents an ephemeral Chat. A set of messages spawned around an Support Request or something of the like |
| [Thread](-thread/index.md) | [common]<br>[Thread](-thread/index.md)<br>Represents a conversation in reply to a particular message. Does not include nested threads. |
| [Unknown](-unknown/index.md) | [common]<br>[Unknown](-unknown/index.md) |

## Properties

| Name | Summary |
|---|---|
| [entries](entries.md) | [common]<br>val [entries](entries.md): [EnumEntries](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.enums/-enum-entries/index.html)&lt;[ChatType](index.md)&gt;<br>Returns a representation of an immutable list of all enum entries, in the order they're declared. |

## Functions

| Name | Summary |
|---|---|
| [valueOf](value-of.md) | [common]<br>fun [valueOf](value-of.md)(value: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)): [ChatType](index.md)<br>Returns the enum constant of this type with the specified name. The string must match exactly an identifier used to declare an enum constant in this type. (Extraneous whitespace characters are not permitted.) |
| [values](values.md) | [common]<br>fun [values](values.md)(): [Array](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-array/index.html)&lt;[ChatType](index.md)&gt;<br>Returns an array containing the constants of this enum type, in the order they're declared. |
